% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_realign.R
\name{spm12_realign.deprecated}
\alias{spm12_realign.deprecated}
\title{SPM12 Realign (Estimate and Reslice)}
\usage{
spm12_realign.deprecated(
  filename,
  fwhm = 5,
  register_to = c("first", "mean"),
  reslice = c("all", "2:n", "all+mean", "mean"),
  prefix = "r",
  add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE,
  verbose = TRUE,
  outdir = NULL,
  install_dir = NULL,
  ...
)
}
\arguments{
\item{filename}{Files to be realigned and resliced}

\item{fwhm}{Full-Width Half Max to smooth}

\item{register_to}{Should the files be registered to the first or the mean}

\item{reslice}{Options for reslicing all - all images in filename,
2:n - all images in filename 2:length(filename),
all+mean - all images and the mean, mean - mean only}

\item{prefix}{Prefix to append to front of image filename}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{outdir}{Directory to copy results.
If full filename given, then results will
be in \code{dirname(filename)}}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
Result from run_matlab_script
}
\description{
Performs SPM12 realignment estimation 
and reslicing on an Image
}
