% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spautorRF.R
\name{spautorRF}
\alias{spautorRF}
\title{Fit random forest spatial residual models}
\usage{
spautorRF(formula, data, ...)
}
\arguments{
\item{formula}{A two-sided linear formula describing the fixed effect structure
of the model, with the response to the left of the \code{~} operator and
the terms on the right, separated by \code{+} operators.}

\item{data}{A data frame or \code{sf} object object that contains
the variables in \code{fixed}, \code{random}, and \code{partition_factor}
as well as geographical information. If an \code{sf} object is
provided with \code{POINT} geometries, the x-coordinates and y-coordinates
are used directly. If an \code{sf} object is
provided with \code{POLYGON} geometries, the x-coordinates and y-coordinates
are taken as the centroids of each polygon.}

\item{...}{Additional named arguments to \code{ranger::ranger} or \code{\link[=spautor]{spautor()}}.}
}
\value{
A list with several elements to be used with \code{predict()}. These
elements include the function call (named \code{call}), the random forest object
fit to the mean (named \code{ranger}),
the spatial linear model object fit to the residuals
(named \code{spmod} or \code{spmod_list}), and an object can contain data for
locations at which to predict (called \code{newdata}). The \code{newdata}
object contains the set of
observations in \code{data} whose response variable is \code{NA}.
If \code{spcov_type} or \code{spcov_initial} (which are passed to \code{\link[=spautor]{spautor()}})
are length one, the list has class \code{spmodRF} and the spatial linear
model object fit to the residuals is called \code{spmod}, which has
class \code{spmod}. If
\code{spcov_type} or \code{spcov_initial} are length greater than one, the
list has class \code{spmodRF_list} and the spatial linear model object
fit to the residuals is called \code{spmod_list}, which has class \code{spmod_list}.
and contains several objects, each with class \code{spmod}.
}
\description{
Fit random forest residual spatial linear models
for areal data (i.e., spatial autoregressive models) using
random forest to fit the mean and a spatial linear model to fit the residuals.
The spatial linear model fit to the residuals can incorporate
a variety of estimation methods, allowing for random effects,
partition factors, and row standardization.
}
\details{
The random forest residual spatial linear model is described by
Fox Et al. (2020). A random forest model is fit to the mean portion of the
model specified by \code{formula} using \code{ranger::ranger()}. Residuals
are computed and used as the response variable in an intercept-only spatial
linear model fit using \code{\link[=spautor]{spautor()}}. This model object is intended for use with
\code{predict()} for perform prediction, also called random forest
regression Kriging.
}
\examples{
\donttest{
seal$var <- rnorm(NROW(seal)) # add noise variable
sprfmod <- spautorRF(log_trend ~ var, data = seal, spcov_type = "car")
predict(sprfmod)
}
}
\references{
Fox, E.W., Ver Hoef, J. M., & Olsen, A. R. (2020). Comparing spatial
regression to random forests for large environmental data sets.
\emph{PloS one}, 15(3), e0229509.
}
