% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.spmod}
\alias{summary.spmod}
\title{Summarize a fitted model object}
\usage{
\method{summary}{spmod}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A list with several fitted model quantities used to create
informative summaries when printing.
}
\description{
Summarize a fitted model object.
}
\details{
\code{summary.spmod()} creates a summary of a fitted model object
intended to be printed using \code{print()}. This summary contains
useful information like the original function call, residuals,
a coefficients table, a pseudo r-squared, and estimated covariance
parameters.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
summary(spmod)
}
\seealso{
\code{\link[=print.summary.spmod]{print.summary.spmod()}}
}
