% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt_bbox.R
\name{bbox2wkt}
\alias{bbox2wkt}
\alias{wkt2bbox}
\title{Convert a bounding box to a Well Known Text polygon, and a WKT to a
bounding box}
\usage{
bbox2wkt(minx = NA, miny = NA, maxx = NA, maxy = NA, bbox = NULL)

wkt2bbox(wkt)
}
\arguments{
\item{minx}{Minimum x value, or the most western longitude}

\item{miny}{Minimum y value, or the most southern latitude}

\item{maxx}{Maximum x value, or the most eastern longitude}

\item{maxy}{Maximum y value, or the most northern latitude}

\item{bbox}{A vector of length 4, with the elements: minx, miny, maxx, maxy}

\item{wkt}{A Well Known Text object.}
}
\value{
bbox2wkt returns an object of class charactere, a Well Known Text
string of the form
'POLYGON((minx miny, maxx miny, maxx maxy, minx maxy, minx miny))'

wkt2bbox returns a numeric vector of length 4, like c(minx, miny,
maxx, maxy).
}
\description{
Convert a bounding box to a Well Known Text polygon, and a WKT to a
bounding box
}
\examples{
# Convert a bounding box to a WKT

## Pass in a vector of length 4 with all values
bbox2wkt(bbox = list(c(-125.0,38.4,-121.8,40.9)))

## Or pass in each value separately
bbox2wkt(-125.0, 38.4, -121.8, 40.9)

# Convert a WKT object to a bounding box
wkt <- "POLYGON((-125 38.4,-125 40.9,-121.8 40.9,-121.8 38.4,-125 38.4))"
wkt2bbox(wkt)

identical(
 bbox2wkt(-125.0, 38.4, -121.8, 40.9),
 "POLYGON((-125 38.4,-125 40.9,-121.8 40.9,-121.8 38.4,-125 38.4))"
)

identical(
 c(-125.0, 38.4, -121.8, 40.9),
 as.numeric(
   wkt2bbox(
     "POLYGON((-125 38.4,-125 40.9,-121.8 40.9,-121.8 38.4,-125 38.4))"
   )
 )
)
}
