% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{ZPvalue}
\alias{ZPvalue}
\title{P-value of Z scores}
\usage{
ZPvalue(
  Z,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH"
)
}
\arguments{
\item{Z}{A matrix of Z scores.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}
}
\value{
A list containing the following:
\itemize{
\item p.val, a matrix of p-values.
\item p.adj, a matrix of adjusted p-values.
}
}
\description{
Calculate p-value of Z scores.
}
\examples{
{
res <- ZPvalue(matrix(runif(100),10,10))
}

}
\concept{stats}
