% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impacts.R
\name{impacts}
\alias{impacts}
\title{Direct, indirect and total effects estimated for a spatial SUR model}
\usage{
impacts(spsurfit, nsim = 1000)
}
\arguments{
\item{spsurfit}{A fitted object of class spsur.}

\item{nsim}{Number of simulations for the randomization procedure. Default = 1000.}
}
\value{
Returns the Direct, Indirect and Total effects of the estimated spatial SUR model and
  simulted significance measures.
  \tabular{ll}{
  \code{table_dir_eff} \tab Table of average direct effects. \cr
  \code{table_ind_eff} \tab Table of average indirect effects. \cr
  \code{table_tot_eff} \tab Table of average total effects. \cr
  }
}
\description{
This function obtains the multiplier effects, on the explained variable, of a change in a regressor
 for the model that has been estimated. For reasons given below, this function
 only applies to models with an autoregressive structure (\strong{"slm"}, \strong{"sdm"} and \strong{"sarar"})
 or with spatial lags of the regressors (\strong{"slx"}, \strong{"sdem"}).\cr
 The measurement of the multiplier effects is a bit more complicated than in a pure time
 series context because, due to the spatial structure of the model, part of the impacts
 spills over non uniformly over the space. Using the notation introduced by LeSage and Pace (2009)
 we distinguish between:

  \itemize{
    \item \strong{Average Direct effects}: The average over the \emph{N} spatial units and
     \emph{Tm} time periods of the effect of a unitary change in the value of a explanatory variable
     on the contemporaneous value of the corresponding explained variable, located in the same point of
     the intervened regressor. This calculus is solved for all the regressors that appear in the \emph{G}
     equations of the model.
    \item \strong{Average Indirect effects}: The average over the \emph{N} spatial units and
     \emph{Tm} time periods of the effects of a unitary change in the value of a explanatory variable
     on the contemporaneous value of the corresponding explained variable, located in a different spatial
     unit that that of the intervened regressor. This calculus is solved for all the regressors that appear in the \emph{G}
     equations of the model.
    \item \strong{Average total effects}: The sum of Direct and Indirect effects.
  }

   The information on the three estimated effects is supplement with an indirect measure of statistical
   significance obtained from the randomization approach introduced in LeSage and Pace (2009).
}
\details{
LeSage and Pace (2009) adapt the classical notion of \emph{'economic multiplier'} to the problem of
 measuring the impact that a unitary change in the value of a regressor, produced in a certain point in space,
 has on the explained variable. The question is interesting because, due to the spatial structure of the model,
 the impacts of such change spill non uniformly over the space. In fact, the reaction of the explained variable
 depends on its relative location in relation to the point of intervention.\cr

 To simplify matters, LeSage and Pace (2009) propose to obtain aggregated multipliers for each regressor,
 just averaging the \eqn{N^{2}} impacts that results from intervening the value of each regressor on each of the
 N points in Space, on the explained variable, measured also in each of the \eqn{N} points in space.
 This aggregated average is the so-called \emph{Total effect}.\cr

 Part of this impact will be absorved by the explained variable located in the same point of the regressor whose
 value has been changed (for example, the k-th regresor in the g-th equation, in the n-th spatial unit) or,
  in other words, we expect that \eqn{[d y_{tgn}]/[d x_{ktgn}] ne 0}. The aggregated average for the
 \emph{N} points in space (n=1,2,...,N) and \emph{Tm} time periods is the so-called \emph{Direct effect}.
 The difference between the \emph{Total effect} and the \emph{Direct effect} measures the portion of the impact
 on the explained variable that leakes to other points in space, \eqn{[d y_{tgn}]/[d x_{ktgm}] for n ne m};
 this is the \emph{Indirect effect}.

 \code{\link{impacts}} obtains the three multipliers together with an indirect measure of statistical significance,
 according to the randomization approach described in Lesage and Pace (2009). Briefly, they suggest to obtain
 a sequence of \emph{nsim} random matrices of order \emph{(NTmxG)} from a multivariate normal distribution
 N(0; \strong{Sigma}), being \strong{Sigma} the estimated covariance matrix of the \emph{G} equations in the SUR
 model. These random matrices, combined with the observed values of the regressors and the estimated values of
 the parameters of the corresponding spatial SUR model, are used to obtain simulated values of the explained
 variables. Then, for each one of the \emph{nsim} experiments, the SUR model is estimated, and the effects
 are evaluated. The function \code{\link{impacts}} obtains the standard deviations of the \emph{nsim} estimated
 effects in the randomization procedure, which are used to test the significance of the estimated effects for the
 original data.

 Finally, let us note that this is a SUR model where the \emph{G} equations are connected only through the error
 terms. This means that if we intervene a regressor in equation \emph{g}, in any point is space, only the explained
 variable of the same equation \emph{g} should react. The impacts do not spill over equations.
 Moreover, the impact of a regressor, intervened in the spatial unit \emph{n}, will
 cross the borders of this spatial unit only if in the right hand side of the equation there are spatial lags of the
 explained variables or of the regressors. In other words, the \emph{Indirect effect} is zero for the
 \strong{"sim"} and \strong{"sem"} models. \code{\link{impacts}} produces no output for these two models.
 Lastly, it is clear that all the impacts are contemporaneous because the equations in the SUR model
 have no time dynamics.
}
\examples{

####################################
### PURE CROSS SECTIONAL DATA ######
##########  (G>1; Tm=1)  ###########
####################################

#### Example 1: Spatial Phillips-Curve. Anselin (1988, p. 203)
rm(list = ls()) # Clean memory
data(spc)
Tformula <- WAGE83 | WAGE81 ~ UN83 + NMR83 + SMSA | UN80 + NMR80 + SMSA
## A SUR-SLM model.
spcsur.slm <-spsur3sls(Form = Tformula, data = spc, type = "slm", W = Wspc)
summary(spcsur.slm)
eff.spcsur.slm <- impacts(spcsur.slm, nsim = 30)

}
\references{
\itemize{
     \item LeSage, J., and Pace, R. K. (2009). \emph{Introduction to spatial
       econometrics}. Chapman and Hall/CRC.
       \item López, F.A., Mur, J., and Angulo, A. (2014). Spatial model
       selection strategies in a SUR framework. The case of regional
       productivity in EU. \emph{Annals of Regional Science}, 53(1), 197-220.
      \item Mur, J., López, F., and Herrera, M. (2010). Testing for spatial
      effects in seemingly unrelated regressions. \emph{Spatial Economic Analysis}, 5(4), 399-440.
  }
}
\seealso{
\code{\link{spsurml}},  \code{\link{spsur3sls}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Jesús Mur  \tab \email{jmur@unizar.es} \cr
  }
}
