% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_balance.R
\name{sp_balance}
\alias{sp_balance}
\title{Calculate spatial balance metrics}
\usage{
sp_balance(
  object,
  sframe,
  stratum_var = NULL,
  ip = NULL,
  metrics = "pielou",
  extents = FALSE
)
}
\arguments{
\item{object}{An \code{sf} object containing some design sites.}

\item{sframe}{The sampling frame as an \code{sf} object. The coordinate
system for \code{sframe} must be one where distance for coordinates is meaningful.}

\item{stratum_var}{The name of the stratum variable in \code{object}
and \code{sframe}. If \code{NULL} (the default), no strata is assumed.
If a single character vector is provided, it is assumed this is the
name of the stratum variable in \code{object} and \code{sframe}. If
a two-dimensional character vector is provided, one element must be
named "object" and corresponds to the name of the stratum variable
in \code{object}, while the other element must be named "sframe" and
corresponds to the name of the stratum variable in \code{sframe}.}

\item{ip}{Inclusion probabilities associated with each row of \code{sframe}.
If these are not provided, an equal probability design is assumed (within
strata).}

\item{metrics}{A character vector of spatial balance metrics:
\describe{
  \item{\code{pielou}}{ Pielou's Evenness Index (the default). This statistic
    can take on a value between zero and one.}
  \item{\code{simpsons}}{ Simpsons Evenness Index. This statistic
    can take on a value between zero and logarithm of the sample size.}
  \item{\code{rmse}}{ Root-Mean-Squared Error. This statistic
    can take on a value between zero and infinity.}
  \item{\code{mse}}{ Mean-Squared Error. This statistic
    can take on a value between zero and infinity.}
  \item{\code{mae}}{ Median-Absolute Error. This statistic
    can take on a value between zero and infinity.}
  \item{\code{medae}}{ Mean-Absolute Error. This statistic
    can take on a value between zero and infinity.}
  \item{\code{chisq}}{ Chi-Squared Loss. This statistic
    can take on a value between zero and infinity.}
 }
  All spatial balance metrics have a lower bound of zero, which indicates perfect
  spatial balance. As the metric value increases, the spatial balance decreases.}

\item{extents}{Should the extent (total units) within each Voronoi polygon
be returned? Defaults to \code{FALSE}.}
}
\value{
A data frame with columns providing the stratum (\code{stratum}),
  spatial balance metric (\code{metric}), and spatial balance (\code{value}).
}
\description{
This function measures the spatial balance (with respect to the
sampling frame) of design sites using
Voronoi polygons (Dirichlet tessellations).
}
\examples{
sample <- grts(NE_Lakes, 30)
sp_balance(sample$sites_base, NE_Lakes)
strata_n <- c(low = 25, high = 30)
sample_strat <- grts(NE_Lakes, n_base = strata_n, stratum_var = "ELEV_CAT")
sp_balance(sample_strat$sites_base, NE_Lakes, stratum_var = "ELEV_CAT", metric = "rmse")
}
\author{
Michael Dumelle \email{Dumelle.Michael@epa.gov}
}
