\name{savemat}
\alias{savemat}
\title{Save a matrix as a raster image file}
\description{Save a matrix as a PNG, TIFF, BMP, JPEG, or PDF image file, such that each pixel corresponds to exactly one element
of the matrix.  }
\usage{
savemat(x, filename, map = NULL, outlier = NULL,
       dev = c('png', 'pdf', 'bmp', 'tiff', 'jpeg'), 
       do.dev.off = TRUE, ...)
}
\arguments{
  \item{x}{ A matrix }
  \item{filename}{ Filename }
  \item{map}{ (Optional) a list, as generated by \code{\link{makecmap}}. }
  \item{outlier}{ (Optional) A color for outliers, if \code{map} is specified. }
  \item{dev}{ Which graphics device to use. }
  \item{\dots}{ Further arguments passed to the graphics device; see \code{\link{png}} or \code{\link{pdf}}. }
  \item{do.dev.off}{ Close graphics device when finished? }
 }
\details{ 
This function is a relatively simple wrapper around the usual graphics device with the same name as \code{dev}. The idea is to provide an easy way of creating an image file from a matrix, without axes, plotting frame, labels, etc.  

For all choices of \code{dev} except \code{"pdf"}, the output image dimensions are set to match the matrix size, such that each pixel corresponds to an element of the matrix. 

If \code{map} is \code{NULL} (the default), the matrix is interpreted as a matrix of colors.

If \code{map} is specified, it is used to translate 
the numeric matrix \code{x} into a matrix of colors,
using \code{\link{cmap}}.
}
\value{ None. }
\seealso{ \code{\link{cimage}} for drawing a matrix on the screen. }
\examples{  
\dontrun{
  big.color.matrix <- matrix(rep(colors()[1:625], 16), nrow = 100)
  
  ## save as a PNG
  savemat(big.color.matrix, file = 'test.png')

}
}
\keyword{ misc }
