% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.r
\name{cascade}
\alias{cascade}
\title{Summarise multiple values into cascading groups}
\usage{
cascade(.data, ..., .dots, .fill = NA)
}
\arguments{
\item{.data, }{tbl A \code{tbl_svy} object}

\item{...}{Name-value pairs of summary functions}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse", package = "dplyr")} for details.}

\item{.fill}{Value to fill in for group summaries}
}
\description{
\code{cascade} is similar to \code{\link{summarise}}, but calculates
a summary statistics for the total of a group in addition to each group.
}
\examples{
library(survey)
data(api)

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

dstrata_grp <- dstrata \%>\%
  group_by(stype)

dstrata_grp \%>\%
  cascade(api99_mn = survey_mean(api99),
            api00_mn = survey_mean(api00),
            api_diff = survey_mean(api00 - api99))

}
