% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_rec_devs.r
\name{change_rec_devs}
\alias{change_rec_devs}
\title{Replace recruitment deviations}
\usage{
change_rec_devs(recdevs_new, par_file_in = "ss3.par",
  par_file_out = "ss3.par")
}
\arguments{
\item{recdevs_new}{A vector of new recruitment deviations.}

\item{par_file_in}{A string providing the path to the input SS3 \code{.par} file.}

\item{par_file_out}{A string providing the path to the output SS3 \code{.par} file.}
}
\value{
A modified SS3 \code{.par} file.
}
\description{
This function replaces the recruitment deviations in the
\code{ss3.par} file with those specified in \code{recdevs_new}, as
well as a comment (for debugging). It then writes a new file with
name \code{par_file_out} into the working directory.
}
\details{
This function does not need to be specified in a case file if you
  are running and ss3sim simulation through case files with
  \code{\link{run_ss3sim}}.
}
\examples{
# Create a temporary folder for the output:
temp_path <- file.path(tempdir(), "ss3sim-recdev-example")
dir.create(temp_path, showWarnings = FALSE)

par_file <- system.file("extdata", "models", "cod-om", "ss3.par",
  package = "ss3sim")
change_rec_devs(recdevs_new = rlnorm(100), par_file_in = par_file,
  par_file_out = paste0(temp_path, "/test.par"))
}
\author{
Cole Monnahan
}

