% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_year.R
\name{change_year}
\alias{change_year}
\title{Methods to change the years in an ss3sim model}
\usage{
change_year(year_begin = 1, year_end = 100, burnin = 0,
  ctl_file_in = NULL, ctl_file_out = "new.ctl", dat_file_in = NULL,
  dat_file_out = "new.dat", par_file_in = NULL, par_file_out = "new.ss",
  str_file_in = NULL, str_file_out = "starter.ss", for_file_in = NULL,
  for_file_out = "forecast.ss", verbose = FALSE)
}
\arguments{
\item{year_begin}{Desired start year}

\item{year_end}{Desired end year}

\item{burnin}{Length of burnin period. Default is zero for an OM. Use burnin
for EM models, to establish a period with no fishing.
Note that the value should correspond to the number of years, not a year
value.}

\item{ctl_file_in}{A string providing the path to the input SS3 \code{.ctl} file.}

\item{ctl_file_out}{Output SS3 control file, if \code{NULL} the file will be
named the same as the \code{ctl_file_in}}

\item{dat_file_in}{A string providing the path to the input SS3 \code{.dat} file.}

\item{dat_file_out}{Output SS3 data file, if \code{NULL} the file will be
named the same as the \code{dat_file_in}}

\item{par_file_in}{A string providing the path to the input SS3 \code{.par} file.}

\item{par_file_out}{Output SS3 parameter file, if \code{NULL} the file will
be named the same as the \code{par_file_in}}

\item{str_file_in}{A string providing the path to the input SS3 \code{starter.ss} file.}

\item{str_file_out}{Output SS3 starter file, if \code{NULL} the file will
be named the same as the \code{str_file_in}}

\item{for_file_in}{Input SS3 forecast file}

\item{for_file_out}{Output SS3 forecast file, if \code{NULL} the file
will be named the same as the \code{for_file_in}}

\item{verbose}{Logical argument that is passed on to internal calls to r4ss
functions for reading and writing SS3 files. Setting \code{verbose} to
\code{TRUE} may be useful for troubleshooting.}
}
\value{
The function creates modified versions of the \code{.par},
  \code{.dat}, \code{.ctl}, \code{.starter}, and \code{.forecast} files.
}
\description{
\code{change_year} takes SS3 \code{.ctl}, \code{.dat}, \code{.par},
\code{starter.ss}, and \code{.forecast} files and changes the start and end
year of the model. \code{change_year} works with \pkg{ss3sim} operating or
estimation models.
}
\details{
Operating models and estimation models will not have all of the same files,
thus if the file does not exist change the \code{_file_in} to \code{NULL}.
The code will add data for all years specified, minus the burnin period,
if the data type is present in the \code{dat_file_in} file.
The manipulation performed on the \code{dat_file_in} file is not complete
and users will need
to specify data for years which are deleted. The function removes all composition
data except for the first year.
To remove data use \code{\link{sample_index}}, \code{\link{sample_lcomp}},
or \code{\link{sample_agecomp}}.
For models that use the \code{.forecast} file, all references to years
must be made with relative values (i.e., 0 or negative integers).
}
\examples{
\dontrun{
# Create a temporary folder for the output and set the working directory:
wd.old <- getwd()
temp_path <- file.path(tempdir(), "change_year-example")
dir.create(temp_path, showWarnings = FALSE)
setwd(temp_path)

# Find the SS3 "Simple" model in the package data:
d <- system.file("extdata", package = "ss3sim")
simple <- paste0(d, "/Simple")
dir.create("Simple")
file.copy(simple, ".", recursive = TRUE)
setwd("Simple")

# Run SS3 to create control.ss_new and Report.sso:
system("SS3_24o_safe starter.ss -noest")

change_year(year_begin = 1, year_end = 100, burnin = 25,
 ctl_file_in = "control.ss_new", ctl_file_out = "change_year.ctl",
 dat_file_in = "simple.dat", dat_file_out = "change_year.dat",
 par_file_in = "ss3.par", par_file_out = "change_year.par",
 str_file_in = "starter.ss", str_file_out = "change_year_starter.ss",
 for_file_in = "forecast.ss", for_file_out = "change_year_forecast.ss")

# Clean up:
setwd("../")
unlink("Simple")
setwd(wd.old)
}
}
\author{
Kelli Johnson
}
