% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCA_helpers.R
\name{scores.OD}
\alias{scores.OD}
\title{Orthogonal Distances for PCAloc}
\usage{
scores.OD(X, PC, groups, ssMRCD)
}
\arguments{
\item{X}{data matrix of observations.}

\item{PC}{loadings of sparse local PCA.}

\item{groups}{grouping vector for locality.}

\item{ssMRCD}{ssMRCD object used for PCA calculation.}
}
\value{
Returns vector of orthogonal distances of observations.
}
\description{
Orthogonal Distances for PCAloc
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
loccovs = ssMRCD(x, weights = W, lambda = 0.5)

# calculate PCA
pca = sparsePCAloc(eta = 1, gamma = 0.5, cor = FALSE,
                   COVS = loccovs$MRCDcov,
                   increase_rho = list(FALSE, 20, 1))

# calculate scores
scores.OD(X = rbind(x1, x2), PC = pca$PC,
          groups = rep(c(1,2), each = 100), ssMRCD = loccovs)

}
\seealso{
\code{\link[ssMRCD]{scores}}, \code{\link[ssMRCD]{scores.SD}}, \code{\link[ssMRCD]{sparsePCAloc}}, \code{\link[ssMRCD]{scale_ssMRCD}}
}
