% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrrIII3.R, R/gamma.R, R/gompertz.R,
%   R/invpareto.R, R/lgumbel.R, R/llogis-llogis.R, R/llogis.R, R/lnorm-lnorm.R,
%   R/lnorm.R, R/pqr.R, R/weibull.R
\name{ssd_pburrIII3}
\alias{ssd_pburrIII3}
\alias{ssd_pgamma}
\alias{ssd_pgompertz}
\alias{pgompertz}
\alias{ssd_pinvpareto}
\alias{ssd_plgumbel}
\alias{plgumbel}
\alias{ssd_pllogis_llogis}
\alias{ssd_pllogis}
\alias{ssd_plnorm_lnorm}
\alias{ssd_plnorm}
\alias{ssd_p}
\alias{ssd_pweibull}
\title{Cumulative Distribution Function}
\usage{
ssd_pburrIII3(
  q,
  shape1 = 1,
  shape2 = 1,
  scale = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_pgamma(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

ssd_pgompertz(q, location = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

pgompertz(q, llocation = 0, lshape = 0, lower.tail = TRUE, log.p = FALSE)

ssd_pinvpareto(q, shape = 3, scale = 1, lower.tail = TRUE, log.p = FALSE)

ssd_plgumbel(
  q,
  locationlog = 0,
  scalelog = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

plgumbel(q, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_pllogis_llogis(
  q,
  locationlog1 = 0,
  scalelog1 = 1,
  locationlog2 = 1,
  scalelog2 = 1,
  pmix = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_pllogis(q, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_plnorm_lnorm(
  q,
  meanlog1 = 0,
  sdlog1 = 1,
  meanlog2 = 1,
  sdlog2 = 1,
  pmix = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

ssd_plnorm(q, meanlog = 0, sdlog = 1, lower.tail = TRUE, log.p = FALSE)

ssd_pweibull(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{shape1}{shape1 parameter.}

\item{shape2}{shape2 parameter.}

\item{scale}{scale parameter.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{location}{location parameter.}

\item{llocation}{location parameter on the log scale.}

\item{lshape}{shape parameter on the log scale.}

\item{locationlog}{location on log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{locationlog1}{locationlog1 parameter.}

\item{scalelog1}{scalelog1 parameter.}

\item{locationlog2}{locationlog2 parameter.}

\item{scalelog2}{scalelog2 parameter.}

\item{pmix}{Proportion mixture parameter.}

\item{meanlog1}{mean on log scale parameter.}

\item{sdlog1}{standard deviation on log scale parameter.}

\item{meanlog2}{mean on log scale parameter.}

\item{sdlog2}{standard deviation on log scale parameter.}

\item{meanlog}{mean on log scale parameter.}

\item{sdlog}{standard deviation on log scale parameter.}
}
\description{
Cumulative Distribution Function
}
\section{Functions}{
\itemize{
\item \code{ssd_pburrIII3}: Cumulative Distribution Function for BurrIII Distribution

\item \code{ssd_pgamma}: Cumulative Distribution Function for Gamma Distribution

\item \code{ssd_pgompertz}: Cumulative Distribution Function for Gompertz Distribution

\item \code{pgompertz}: Cumulative Distribution Function for Gompertz Distribution
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{ssd_pinvpareto}: Cumulative Distribution Function for Inverse Pareto Distribution

\item \code{ssd_plgumbel}: Cumulative Distribution Function for Log-Gumbel Distribution

\item \code{plgumbel}: Cumulative Distribution Function for Log-Gumbel Distribution
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{ssd_pllogis_llogis}: Cumulative Distribution Function for Log-Logistic/Log-Logistic Mixture Distribution

\item \code{ssd_pllogis}: Cumulative Distribution Function for Log-Logistic Distribution

\item \code{ssd_plnorm_lnorm}: Cumulative Distribution Function for Log-Normal/Log-Normal Mixture Distribution

\item \code{ssd_plnorm}: Cumulative Distribution Function for Log-Normal Distribution

\item \code{ssd_pweibull}: Cumulative Distribution Function for Weibull Distribution
}}

\examples{

ssd_pburrIII3(1)

ssd_pgamma(1)

ssd_pgompertz(1)

ssd_pinvpareto(1)

ssd_plgumbel(1)

ssd_pllogis_llogis(1)

ssd_pllogis(1)

ssd_plnorm_lnorm(1)

ssd_plnorm(1)

ssd_pweibull(1)
}
\seealso{
\code{\link{ssd_q}} and \code{\link{ssd_r}}
}
