% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-data.R
\name{ssd_plot_data}
\alias{ssd_plot_data}
\title{Plot Species Sensitivity Data}
\usage{
ssd_plot_data(
  data,
  left = "Conc",
  right = left,
  label = NULL,
  shape = NULL,
  color = NULL,
  size = 2.5,
  xlab = "Concentration",
  ylab = "Species Affected",
  shift_x = 3,
  bounds = c(left = 1, right = 1),
  xbreaks = waiver()
)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{label}{A string of the column in data with the labels.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{color}{A string of the column in data for the color aesthetic.}

\item{size}{A number for the size of the labels.}

\item{xlab}{A string of the x-axis label.}

\item{ylab}{A string of the x-axis label.}

\item{shift_x}{The value to multiply the label x values by.}

\item{bounds}{A named non-negative numeric vector of the left and right bounds for
uncensored missing (0 and Inf) data in terms of the orders of magnitude
relative to the extremes for non-missing values.}

\item{xbreaks}{The x-axis breaks as one of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks
\item A numeric vector of positions
}}
}
\description{
Plots species sensitivity data.
}
\examples{
ssd_plot_data(ssddata::ccme_boron, label = "Species", shape = "Group")
}
\seealso{
\code{\link[=ssd_plot]{ssd_plot()}} and \code{\link[=geom_ssdpoint]{geom_ssdpoint()}}
}
