% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ssizeRNA_single.R
\name{ssizeRNA_single}
\alias{ssizeRNA_single}
\title{Sample Size Calculations for Two-Sample RNA-seq Experiments with Single Set of Parameters}
\usage{
ssizeRNA_single(nG = 10000, pi0 = 0.95, mu, disp, logfc, up = 0.5,
  replace = TRUE, m = 200, fdr = 0.05, power = 0.8, maxN = 35,
  side = "two-sided", cex.title = 1.15, cex.legend = 1)
}
\arguments{
\item{nG}{total number of genes.}

\item{pi0}{a vector (or scalar) of proportions of non-differentially expressed genes.}

\item{mu}{a scalar of mean counts in control group from which to simulate.}

\item{disp}{a scalar of dispersion parameter from which to simulate.}

\item{logfc}{log fold change between treatment group and control group.}

\item{up}{proportion of up-regulated genes among all differentially expressed genes, the default value is \code{0.5}.}

\item{replace}{sample with or without replacement from given parameters. See Details for more information.}

\item{m}{pseudo sample size for generated data.}

\item{fdr}{the false discovery rate to be controlled.}

\item{power}{the desired power to be achieved.}

\item{maxN}{the maximum sample size used for power calculations.}

\item{side}{options are "two-sided", "upper", or "lower".}

\item{cex.title}{controls size of chart titles.}

\item{cex.legend}{controls size of chart legend.}
}
\value{
\item{ssize}{sample sizes (for each treatment) at which desired power is first reached.}

\item{power}{power calculations with corresponding sample sizes.}

\item{crit.vals}{critical value calculations with corresponding sample sizes.}
}
\description{
This function calculates appropriate sample sizes for two-sample RNA-seq experiments for a desired power
in which mean and dispersion parameters are identical for all genes.
Sample size calculations are performed at controlled false discovery rates, user-specified proportions
of non-differentially expressed genes, mean counts in control group, dispersion, and log fold change.
A plot of power versus sample size is generated.
}
\details{
If a vector is input for \code{pi0}, sample size calculations are performed for each proportion.

If the total number of genes is larger than length of \code{mu} or \code{disp},
\code{replace} always equals \code{TRUE}.
}
\examples{
p0 <- 0.8                                ## proportion of non-differentially expressed genes
mu <- 10                                 ## mean counts in control group for all genes
disp <- 0.1                              ## dispersion for all genes
logfc <- log(2)                          ## log fold change for up-regulated genes

size <- ssizeRNA_single(pi0 = p0, mu = mu, disp = disp, logfc = logfc, m = 30, maxN = 20)
size$ssize                               ## first sample size to reach desired power
size$power                               ## calculated power for each sample size
size$crit.vals                           ## calculated critical value for each sample size
}
\author{
Ran Bi \email{biran@iastate.edu}, Peng Liu \email{pliu@iastate.edu}
}
\references{
Liu, P. and Hwang, J. T. G. (2007) Quick calculation for sample size while controlling
false discovery rate with application to microarray analysis. \emph{Bioinformatics} 23(6): 739-746.

Orr, M. and Liu, P. (2009) Sample size estimation while controlling false discovery rate for microarray
experiments using ssize.fdr package. \emph{The R Journal}, 1, 1, May 2009, 47-53.

Law, C. W., Chen, Y., Shi, W., Smyth, G. K. (2014). Voom: precision weights unlock linear model analysis tools for
RNA-seq read counts. \emph{Genome Biology} 15, R29.
}
\seealso{
\code{\link{ssizeRNA_vary}}
}

