% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarioRisk-base.R
\name{scenarioRisk}
\alias{scenarioRisk}
\title{Constructing a scenarioRisk}
\usage{
scenarioRisk(name, probability, currency, effect)
}
\arguments{
\item{name}{character value. The names of the scenarios. This should not contain
duplicated names.}

\item{probability}{numeric value. The probability of the respective
scenarios. Probabilities must take values between 0 and 1, i.e. must be in (0, 1).}

\item{currency}{character value. The currencies in which the effect are expressed.
Please note that \code{currency} is restricted to be the same as the base currency
of a marketRisk.}

\item{effect}{numeric value. The effects associated with each
scenario on the risk-bearing-capital (RBC). This must be expressed
in the same currency as \code{currency}.}
}
\value{
An S3 object, instance of the class \code{scenarioRisk}.
}
\description{
\code{scenarioRisk} is the constructor for the
  S3 class scenarioRisk. It allows to build for scenarios (stress-tests).
}
\note{
All parameters must be of equal length.
}
\examples{
# Creating new scenarioRisk.
scenarios <- scenarioRisk(name        = c("earthquake",
                                          "real estate crash"),
                          probability = c(0.001, 0.01),
                          currency    = c("CHF", "CHF"),
                          effect        = c(1000, 10000))

}
\seealso{
\code{\link{summary.scenarioRisk}}, \code{\link{print.scenarioRisk}},
  \code{\link{simulate.scenarioRisk}}, \code{\link{compute.scenarioRisk}}.
}
