% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{smart_impactmat}
\alias{smart_impactmat}
\title{Create a random VAR model \eqn{(dxd)} error impact matrix \eqn{B}
  fairly close to the given \strong{invertible} impact matrix.}
\usage{
smart_impactmat(d, B, accuracy, is_regime1 = TRUE)
}
\arguments{
\item{B}{an invertible \eqn{(dxd)} impact matrix specifying
expected value of the matrix to be generated. Should have strictly positive diagonal entries in
a decreasing order.}

\item{accuracy}{a positive real number adjusting how close to the given impact matrix
the returned individual should be. Larger value implies higher accuracy.}

\item{is_regime1}{is the impact matrix for Regime 1? Regime 1 impact matrix is constrained so the elements
in its first row are in a decreasing ordering and the diagonal elements are strictly positive.}
}
\value{
Returns a \eqn{(d^2 \times 1)} vector containing the vectorized impact matrix \eqn{B}.
}
\description{
\code{smart_impactmat} generates a random VAR model \eqn{(dxd)} error impact matrix \eqn{B}
  fairly close to the given \strong{invertible} impact matrix.
}
\keyword{internal}
