% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gge_biplot.R
\name{gge_biplot}
\alias{gge_biplot}
\alias{gge_biplot.default}
\title{Genotype plus Genotypes by Environment (GGE) Interaction Biplot}
\usage{
gge_biplot(.data, .y, .rep, .gen, .env)

\method{gge_biplot}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Stability Measures
}
\description{
Plots Genotype plus Genotypes by Environment (GGE) Interaction Biplot for Genotypes by Environment Interaction (GEI)
}
\examples{

data(ge_data)
     gge_biplot(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )



}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
