% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor2cov.R
\name{cor2cov}
\alias{cor2cov}
\title{Back transform correlation matrix to variance-covariance matrix}
\usage{
cor2cov(V, sd = sqrt(diag(V)))
}
\arguments{
\item{V}{a variance covariance matrix}

\item{sd}{a vector of standard deviations - if ommitted, use the sqrt of the diagonal of V}
}
\value{
a variance-covariance matrix
}
\description{
Compute a variance-covariance matrix from a correlation matrix and standard deviations.
}
\examples{
stopifnot(all.equal(
  cor2cov(cor(mtcars), sapply(mtcars, sd)), 
  cov(mtcars)
))
}
\references{
\url{https://stackoverflow.com/questions/18740796/generate-covariance-matrix-from-correlation-matrix}
}
\seealso{
\code{\link[stats]{cor}}
}
\author{
\href{https://stackoverflow.com/users/767760/s4m}{S4M},
}
