require(stacomiR)
# launching stacomi without selecting the scheme or interface
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
# the following script will load the Arzal dataset 
#if connected to iav schema
\dontrun{
  #create an instance of the class
  r_sample_char<-new("report_sample_char")
  # the following will load data for size, 
  # parameters 1786 (total size) C001 (size at video control)
  # dc 5 and 6 are fishways located on the Arzal dam
  # two stages are selected
  r_sample_char<-choice_c(r_sample_char,
	  dc=c(5,6),
	  taxa=c("Anguilla anguilla"),
	  stage=c("AGJ","CIV"),
	  par=c(1785,1786,1787,"C001"),
	  horodatedebut="2013-01-01",
	  horodatefin="2013-12-31",
	  silent=FALSE)
  # two warning produced, ignored if silent=TRUE
  r_sample_char<-connect(r_sample_char)
  r_sample_char<-calcule(r_sample_char,silent=TRUE)
  
}	
# load the dataset generated by previous lines
data("r_sample_char")

# A "violin" plot
plot(r_sample_char,plot.type="1",silent=TRUE)
# get the plot from envir_stacomi to change labels for name
# if you use require(ggplot2) the :: argument is not needed
# e.g. write require(ggplot2);g<-get("g",envir=envir_stacomi)
# g+xlab("size")+ylab("year")
if (requireNamespace("ggplot2", quietly = TRUE)){
  g<-get("g",envir=envir_stacomi)
  g+ggplot2::xlab("size")+ggplot2::ylab("year")
}
# A boxplot per month
plot(r_sample_char,plot.type="2",silent=TRUE)
# A xyplot
plot(r_sample_char,plot.type="3",silent=TRUE)

\dontrun{
  
  #####################################
# an example graph created manually from data
  #####################################
# two variables one on DC, one on stage
# passing dc information to the stage variable
  r_sample_char@data$std_libelle[r_sample_char@data$ope_dic_identifiant==5]<-
      "Yellow eel (vert. slot fishway)"
  r_sample_char@data$std_libelle[r_sample_char@data$std_libelle=="Anguille jaune"]<-
      "Yellow eel (ramp)"
  r_sample_char@data$std_libelle[r_sample_char@data$std_libelle=="civelle"]<-
      "Glass eel (ramp)"
# creating a boxplot with custom output : an example
# again if you use require(ggplot2) the :: argument is not needed
  
  if (requireNamespace("ggplot2", quietly = TRUE)){
	g<-ggplot2::ggplot(r_sample_char@data)+
		ggplot2::geom_boxplot(ggplot2::aes(x=annee,
				y =car_valeur_quantitatif,
				fill = std_libelle))+		
		ggplot2::xlab("size")+ggplot2::ylab("year")+
		ggplot2::scale_fill_manual("stage & fishway",
			values=c("Yellow eel (vert. slot fishway)"="blue",
				"Yellow eel (ramp)"="turquoise3",
				"Glass eel (ramp)"="Cyan"))+
		ggplot2::theme_bw()
	print(g)
  }
  
# get a simple summary using Hmisc::describe
  
  summary(r_sample_char)
# get the command line to create the object using choice_c 
# when the graphical interface has been used
  print(r_sample_char)
}
