% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_mig.R
\docType{class}
\name{report_mig-class}
\alias{report_mig-class}
\alias{report_mig}
\title{Migration report for one DC, one species and one stage}
\description{
This class performs a migration summary. A migration monitoring operation can correspond to a single
horodate (in the case of some video monitoring operation) or comprise a period which does not necessarily
span a full day. The daily migration is calculated by splitting the operation between days, and the migration is either
grouped or split according to the lenth of the different time spans.
}
\section{Slots}{

\describe{
\item{\code{dc}}{Object of class \link{ref_dc-class}: the control device}

\item{\code{taxa}}{Object of class \link{ref_taxa-class}: the species}

\item{\code{stage}}{Object of class \link{ref_stage-class} : the stage of the fish}

\item{\code{timestep}}{Object of class \link{ref_timestep_daily-class} : the time step 
constrained to daily value and 365 days}

\item{\code{data}}{Object of class \code{data.frame} with data filled in from the connect method}

\item{\code{calcdata}}{A "list" of calculated daily data, one per dc, filled in by the calcule method}

\item{\code{coef_conversion}}{A data.frame of daily weight to number conversion coefficients, filled in by the connect 
method if any weight are found in the data slot.}

\item{\code{time.sequence}}{Object of class \code{POSIXct} : a time sequence of days generated by the calcule method}
}}

\note{
In practise, the report_mig class uses methods (calcule, connect...) from the more elaborate \link{report_mig_mult-class}
}
\examples{
library(stacomiR)

stacomi(gr_interface=FALSE,login_window=FALSE,database_expected=FALSE) 
## launches the application in the command line
## here an example of loading
## not run as the program is possibly not installed
## this example generates the r_mig dataset
\dontrun{
  stacomi(gr_interface=FALSE,
	  login_window=FALSE,
	  database_expected=TRUE)	
  r_mig=new("report_mig")
  r_mig=choice_c(r_mig,
	  dc=5,
	  taxa=c("Liza ramada"),
	  stage=c("IND"),
	  datedebut="2015-01-01",
	  datefin="2015-12-31")
  r_mig<-charge(r_mig)
  # launching charge will also load classes associated with the report
  # e.g. report_ope, report_df, report_dc
  r_mig<-connect(r_mig)
  ########################
# calculations
  ########################
  r_mig<-calcule(r_mig,silent=TRUE)
}
########################
# loading data
## use the following to get the raw data loaded by the connect method
# not shown there as the database and program might not be installed
# All three classes report... were created by the charge and connect method 
# of report_mig_mult
# in the previous example
################################
data("r_mig")
data("r_mig_ope")
assign("report_ope",r_mig_ope,envir=envir_stacomi)
data("r_mig_df")
assign("report_df",r_mig_df,envir=envir_stacomi)
data("r_mig_dc")
assign("report_dc",r_mig_dc,envir=envir_stacomi)


#Individual plot for all DC (standard), taxa and stage where data present
#silent argument to stop all messages
plot(r_mig,plot.type="standard",silent=TRUE)
#cumulated migration at the station (all stages and DC grouped)
plot(r_mig,plot.type="step")

# data will be written in the data directory specified in the stacomi/calcmig.csv
#file

\dontrun{
  summary(r_mig,silent=TRUE)
}
# this will write the daily report for later in in the reportnMigrationInterannuelle-class
\dontrun{
  write_database(r_mig,silent=TRUE,dbname="bd_contmig_nat",host="localhost",port=5432)
}
}
\seealso{
Other report Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_env-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_env-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
