% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{stages.sevt}
\alias{stages.sevt}
\title{Stages of a variable}
\usage{
stages.sevt(object, var = NULL)
}
\arguments{
\item{object}{a staged event tree object}

\item{var}{name of one variable}
}
\value{
If \code{var} is specified, it returns a character vector with
stage names for the given variable
(that is \code{object$stages[[var]]}.
Otherwise, If \code{var} is not specified, \code{stages.sevt}
returns a list of character vectors containing the stages associated
to each variable in the model (that is \code{object$stages}).
}
\description{
Obtain the stages of a given variable in a staged event tree object.
}
\examples{
DD <- generate_xor_dataset(5, 100)
model <- staged_ev_tree(DD, fit = TRUE, lambda = 0)
stages.sevt(model, var = "X5")
}
