% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staple_multi_mat.R
\name{staple_multi_mat}
\alias{staple_multi_mat}
\title{STAPLE on Multi-class matrix}
\usage{
staple_multi_mat(
  x,
  sens_init = 0.99999,
  spec_init = 0.99999,
  max_iter = 10000,
  tol = .Machine$double.eps,
  prior = "mean",
  verbose = TRUE,
  trace = 25,
  ties.method = c("first", "random", "last"),
  drop_all_same = FALSE
)
}
\arguments{
\item{x}{a nxr matrix where there are n raters and r elements rated}

\item{sens_init}{Initialize matrix for sensitivity (p)}

\item{spec_init}{Initialize matrix for specificity (q)}

\item{max_iter}{Maximum number of iterations to run}

\item{tol}{Tolerance for convergence}

\item{prior}{Either "mean" or a matrix of prior probabilities,}

\item{verbose}{print diagnostic messages}

\item{trace}{Number for modulus to print out verbose iterations}

\item{ties.method}{Method passed to \code{\link{max.col}}
for hard segmentation}

\item{drop_all_same}{drop all records where they are all the same.
DO NOT use in practice, only for validation of past results}
}
\value{
List of matrix output sensitivities, specificities, and
matrix of probabilities
}
\description{
STAPLE on Multi-class matrix
}
\examples{
rm(list = ls())
x = matrix(rbinom(5000, size = 5, prob = 0.5), ncol = 1000)
  sens_init = 0.99999
  spec_init = 0.99999
  max_iter = 10000
  tol = .Machine$double.eps
  prior = "mean"
  verbose = TRUE
  trace = 25
  ties.method = "first"

res = staple_multi_mat(x)

}
