% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract2.R
\name{extract2}
\alias{extract2}
\title{Extract raster values by lines or polygons}
\usage{
extract2(x, v, fun, progress = TRUE, ...)
}
\arguments{
\item{x}{A \code{stars} object}

\item{v}{An \code{sf} layer that determines values to extract}

\item{fun}{A function to summarize cell values per feature/band}

\item{progress}{Display progress bar? The default is \code{TRUE}}

\item{...}{Further arguments passed to \code{fun}}
}
\value{
A vector (single-band raster) or \code{matrix} (multi-band raster) with the extracted and summarized values
}
\description{
Extract raster values by lines or polygons, summarizing for each feature using a function specified by the user. This function is aimed to reproduce (some of) the functionality of \code{raster::extract}.
}
\examples{

# Polygons
pol = st_bbox(landsat)
pol = st_as_sfc(pol)
set.seed(1)
pol = st_sample(pol, 5)
pol = st_buffer(pol, 100)
pol = c(pol, pol)

# Plot
plot(landsat[,,,1,drop=TRUE], reset = FALSE)
plot(pol, add = TRUE)

# Single-band raster
aggregate(landsat[,,,1,drop=TRUE], pol, mean, na.rm = TRUE)[[1]]  ## Duplicated areas get 'NA'
extract2(landsat[,,,1,drop=TRUE], pol, mean, na.rm = TRUE, progress = FALSE)

# Multi-band example
extract2(landsat, pol, mean, na.rm = TRUE, progress = FALSE)

# Lines
lines = st_cast(pol, "LINESTRING")

# Single-band raster
extract2(landsat[,,,1,drop=TRUE], lines, mean, na.rm = TRUE, progress = FALSE)

# Multi-band example
extract2(landsat, lines, mean, na.rm = TRUE, progress = FALSE)

}
