% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{tang.test}
\alias{tang.test}
\title{Tang hypothesis testing for random graphs.}
\usage{
tang.test(G1, G2, dim, sigma = NULL, maxBoot = 200)
}
\arguments{
\item{G1}{the first undirected graph to be compared. Must be an igraph
object.}

\item{G2}{the second undirected graph to be compared. Must be an igraph
object.}

\item{dim}{dimension of the adjacency spectral embedding.}

\item{sigma}{a real value indicating the kernel bandwidth. If NULL (default)
the bandwidth is calculated by the method.}

\item{maxBoot}{integer indicating the number of bootstrap resamples
(default is 200).}
}
\value{
A list containing:
\item{T}{the value of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
Given two independent finite-dimensional random dot product graphs,
\code{tang.test} tests if they have generating latent positions that are drawn
from the same distribution.
}
\examples{
set.seed(42)

## test under H0
lpvs <- matrix(rnorm(200), 20, 10)
lpvs <- apply(lpvs, 2, function(x) { return (abs(x)/sqrt(sum(x^2))) })
G1 <- igraph::sample_dot_product(lpvs)
G2 <- igraph::sample_dot_product(lpvs)
D1 <- tang.test(G1, G2, 5)
D1

## test under H1
lpvs2 <- matrix(pnorm(200), 20, 10)
lpvs2 <- apply(lpvs2, 2, function(x) { return (abs(x)/sqrt(sum(x^2))) })
G2 <- suppressWarnings(igraph::sample_dot_product(lpvs2))
D2 <- tang.test(G1, G2, 5)
D2

}
\references{
Tang, Minh, et al. "A nonparametric two-sample hypothesis testing problem for
random graphs." Bernoulli 23.3 (2017): 1599-1630.

Tang, Minh, et al. "A semiparametric two-sample hypothesis testing problem
for random graphs." Journal of Computational and Graphical Statistics 26.2
(2017): 344-354.
}
