% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.takahashi.test.R
\name{graph.takahashi.test}
\alias{graph.takahashi.test}
\title{Test for the Jensen-Shannon divergence between graphs}
\usage{
graph.takahashi.test(Graphs1, Graphs2, maxBoot = 1000, dist = "JS", ...)
}
\arguments{
\item{Graphs1}{a list of undirected Graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{Graphs2}{a list of undirected Graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{maxBoot}{integer indicating the number of bootstrap resamplings (default \code{1000}).}

\item{dist}{string indicating if you want to use the "JS" (default) , "L1" or "L2"
distances. "JS" means Jensen-Shannon divergence.}

\item{...}{Other relevant parameters for \code{\link{graph.spectral.density}}.}
}
\value{
A list with class "htest" containing the following components:
\item{\code{statistic:}}{ the value of the Jensen-Shannon divergence (default), L1 or L2 between 'Graphs1' and 'Graphs2'.}
\item{\code{p.value:}}{ the p-value of the test.}
\item{\code{method:}}{ a string indicating the used method.}
\item{\code{data.name:}}{ a string with the data's name(s).}
}
\description{
\code{graph.takahashi.test} tests whether two sets of graphs were generated by the same
random graph model.
This bootstrap test is based on the Jensen-Shannon (JS) divergence between
graphs.
}
\details{
Given two lists of graphs, \code{Graphs1} and \code{Graphs2}, \code{graph.takahashi.test} tests H0: "JS
divergence between \code{Graphs1} and \code{Graphs2} is \code{0}" against H1: "JS divergence between
\code{Graphs1} and \code{Graphs2} is larger than \code{0}".
}
\examples{
set.seed(1)
G1 <- G2 <- list()
for (i in 1:20) {
  G1[[i]] <- igraph::sample_gnp(n=50, p=0.5)
}
for (i in 1:20) {
  G2[[i]] <- igraph::sample_gnp(n=50, p=0.51)
}
result <- graph.takahashi.test(G1, G2, maxBoot=100)
result

}
\references{
Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{graph_comparison}
