% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/distance_measures.R
\name{jensen_shannon_divergence}
\alias{jensen_shannon_divergence}
\title{Generalized disequilibrium measure for ordinal pattern distributions based on the Jensen-Shannon Divergence}
\usage{
jensen_shannon_divergence(p, q="unif")
}
\arguments{
\item{p}{An ordinal pattern distribution}

\item{q}{A second ordinal pattern distribution to compare against p, or a character vector q="unif" (comparison of p to uniform distribution)}
}
\value{
A vector of length 1.
}
\description{
Computes a normalized form of the Jensen-Shannon Divergence
}
\details{
This function returns a distance measure.
}
\examples{
p = ordinal_pattern_distribution(rnorm(10000), ndemb = 5)
q = ordinal_pattern_distribution(arima.sim(model=list(ar=0.9), n= 10000), ndemb = 5)
jensen_shannon_divergence(p = p, q = q)
}
\author{
Sebastian Sippel
}
\references{
Martin, M.T., Plastino, A. and Rosso, O.A., 2006. Generalized statistical complexity measures: Geometrical and analytical properties. Physica A: Statistical Mechanics and its Applications, 369(2), pp.439-462.
}

