% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{permutation_entropy}
\alias{permutation_entropy}
\title{A function to compute the permutation entropy}
\usage{
permutation_entropy(opd)
}
\arguments{
\item{opd}{A numeric vector that details an ordinal pattern distribution.}
}
\value{
The normalized permutation entropy as a numeric value in the range [0,1].
}
\description{
Computation of the permutation entropy of a time series based on its ordinal pattern distribution (see Bandt and Pompe 2002).
Permutation entropy is a global information measure, hence insensitive to the permutation ordering scheme.
}
\details{
This function calculates the permutation entropy as described in Bandt and Pompe 2002.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
opd = ordinal_pattern_distribution(x = x, ndemb = 6)
permutation_entropy(opd)
}
\author{
Sebastian Sippel
}
\references{
Bandt, C. and Pompe, B., 2002. Permutation entropy: a natural complexity measure for time series. Physical review letters, 88(17), p.174102.
}

