% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSTA.R
\name{summary.STA}
\alias{summary.STA}
\title{Summarizing objects of class \code{STA}}
\usage{
\method{summary}{STA}(
  object,
  trials = NULL,
  trait = NULL,
  nBest = 20,
  sortBy = NULL,
  naLast = TRUE,
  decreasing = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{STA}.}

\item{trials}{A character vector indicating the trial to summarize. If
\code{trial = NULL} a summary is made of all trials in the \code{STA} object.
If a single trial is selected a full summary for this trial is created. For
multiple trials a summary table with the most importantant statistics is
returned.}

\item{trait}{A character string indicating the trait to summarize. If
\code{trait = NULL} and only one trait is modeled, this trait is summarized.}

\item{nBest}{An integer indicating the number of the best genotypes (sorted
by either BLUEs or BLUPs) to print. If \code{NA}, all genotypes will be
printed.}

\item{sortBy}{A character string specifying how the genotypes will be sorted.
Either \code{"BLUEs"}, \code{"BLUPs"} or \code{NA} (i.e. no sorting).}

\item{naLast}{Should missing values in the data be put last when sorting?}

\item{decreasing}{Should the sort order be decreasing?}

\item{...}{Further arguments - not used.}
}
\description{
\code{summary} method for class \code{STA}.
}
\examples{
## Run a single trait analysis using SpATS.
myModel <- fitTD(TD = TDHeat05, design = "res.rowcol", traits = "yield")

## Print a summary of the fitted model.
summary(myModel)

}
\seealso{
Other functions for STA objects: 
\code{\link{STAtoCross}()},
\code{\link{STAtoTD}()},
\code{\link{plot.STA}()},
\code{\link{report.STA}()}
}
\concept{functions for STA objects}
