% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop1.inv}
\alias{ci.prop1.inv}
\title{Confidence interval for a single proportion using inverse sampling}
\usage{
ci.prop1.inv(alpha, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of proportion
\item SE - standard error
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes an exact confidence interval for a single population proportion
when inverse sampling has been used. An approximate standard error is
recovered from the confidence interval. With inverse sampling, the number
of participants who have the attribute (f) is predetermined and sampling
continues until f attains its prespecified value. With inverse sampling,
the sample size (n) will not be known in advance.
}
\examples{
ci.prop1.inv(.05, 5, 67)

# Should return:
#        Estimate         SE         LL        UL
# [1,] 0.07462687 0.03145284 0.02467471 0.1479676


}
\references{
\insertRef{Zou2010}{statpsych}
}
