% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{power.lc.mean.bs}
\alias{power.lc.mean.bs}
\title{Approximates the power of a test for a linear contrast of means for planned
sample sizes in a between-subjects design}
\usage{
power.lc.mean.bs(alpha, n, var, es, v)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{n}{vector of planned sample sizes}

\item{var}{vector of within-group variance planning values}

\item{es}{planning value of linear contrast of means}

\item{v}{vector of contrast coefficients}
}
\value{
Returns the approximate power of the test
}
\description{
Computes the approximate power of a test for a linear contrast of population
mean for planned sample sizes in a between-subject design. The groups can be
the factor levels of a single factor design or the combinations of factors
in a factorial design. For a conservatively low power approximation, set the
variance planning values to the largest values within their plausible ranges,
and set the effect size to a minimally interesting value. The within-group
variances can be unequal across groups and a Satterthwaite degree of freedom
adjustment is used to improve the accuracy of the power approximation.
}
\examples{
n <- c(20, 20, 20, 20)
var <- c(70, 70, 80, 80)
v <- c(.5, .5, -.5, -.5)
power.lc.mean.bs(.05, n, var, 5, v)

# Should return:
#          Power
# [1,] 0.7221139


}
