% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_meta_analysis_expressions.R
\name{expr_meta_parametric}
\alias{expr_meta_parametric}
\title{Making expression with frequentist random-effects meta-analysis
results}
\usage{
expr_meta_parametric(
  data,
  k = 2L,
  conf.level = 0.95,
  output = "subtitle",
  caption = NULL,
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{yi}  and \code{sei} arguments in \code{metafor::rma}
(for parametric analysis) or \code{metaplus::metaplus} (for robust analysis).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{output}{Character describing the desired output. If \code{"subtitle"}, a
formatted subtitle with summary effect and statistical details will be
returned, and if \code{"caption"}, expression containing details from model
summary will be returned.}

\item{caption}{Text to display as caption. This argument is relevant only
when \code{output = "caption"}.}

\item{messages}{Deprecated. Retained only for backward compatibility.}

\item{...}{
  Arguments passed on to \code{\link[metafor:rma.uni]{metafor::rma}}
  \describe{
    \item{\code{vi}}{vector of length \eqn{k} with the corresponding sampling variances. See \sQuote{Details}.}
    \item{\code{weights}}{optional argument to specify a vector of length \eqn{k} with user-defined weights. See \sQuote{Details}.}
    \item{\code{ai}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{bi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ci}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{di}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{n1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{n2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{x1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{x2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{t1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{t2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{m1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{m2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{sd1i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{sd2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{xi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{mi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ri}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ti}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{sdi}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{r2i}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{ni}}{see below and the documentation of the \code{\link[metafor]{escalc}} function for more details.}
    \item{\code{mods}}{optional argument to include one or more moderators in the model. A single moderator can be given as a vector of length \eqn{k} specifying the values of the moderator. Multiple moderators are specified by giving a matrix with \eqn{k} rows and as many columns as there are moderator variables. Alternatively, a model \code{\link{formula}} can be used to specify the model. See \sQuote{Details}.}
    \item{\code{measure}}{character string indicating the type of data supplied to the function. When \code{measure="GEN"} (default), the observed effect sizes or outcomes and corresponding sampling variances (or standard errors) should be supplied to the function via the \code{yi}, \code{vi}, and \code{sei} arguments (only one of the two, \code{vi} or \code{sei}, needs to be specified). Alternatively, one can set \code{measure} to one of the effect size or outcome measures described under the documentation for the \code{\link[metafor]{escalc}} function and specify the needed data via the appropriate arguments.}
    \item{\code{intercept}}{logical indicating whether an intercept should be added to the model (the default is \code{TRUE}). Ignored when \code{mods} is a formula.}
    \item{\code{slab}}{optional vector with labels for the \eqn{k} studies.}
    \item{\code{subset}}{optional (logical or numeric) vector indicating the subset of studies that should be used for the analysis.}
    \item{\code{add}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{to}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{drop00}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{vtype}}{see the documentation of the \code{\link[metafor]{escalc}} function.}
    \item{\code{method}}{character string specifying whether a fixed- or a random/mixed-effects model should be fitted. A fixed-effects model (with or without moderators) is fitted when using \code{method="FE"}. Random/mixed-effects models are fitted by setting \code{method} equal to one of the following: \code{"DL"}, \code{"HE"}, \code{"SJ"}, \code{"ML"}, \code{"REML"}, \code{"EB"}, \code{"HS"}, or \code{"GENQ"}. Default is \code{"REML"}. See \sQuote{Details}.}
    \item{\code{weighted}}{logical indicating whether weighted (default) or unweighted estimation should be used to fit the model.}
    \item{\code{test}}{character string specifying how test statistics and confidence intervals for the fixed effects should be computed. By default (\code{test="z"}), Wald-type tests and CIs are obtained, which are based on a standard normal distribution. When \code{test="knha"}, the method by Knapp and Hartung (2003) is used for adjusting test statistics and confidence intervals. See \sQuote{Details}.}
    \item{\code{digits}}{integer specifying the number of decimal places to which the printed results should be rounded (if unspecified, the default is 4).}
    \item{\code{btt}}{optional vector of indices specifying which coefficients to include in the omnibus test of moderators. Can also be a string to grep for. See \sQuote{Details}.}
    \item{\code{verbose}}{logical indicating whether output should be generated on the progress of the model fitting (the default is \code{FALSE}). Can also be an integer. Values > 1 generate more verbose output. See \sQuote{Note}.}
    \item{\code{control}}{optional list of control values for the iterative estimation algorithms. If unspecified, default values are defined inside the function. See \sQuote{Note}.}
  }}
}
\description{
This analysis is carried out using the \code{metafor} package. For
more, see \code{?metafor::rma}.
}
\examples{
\donttest{
# setup
set.seed(123)
library(statsExpressions)
library(metaplus)

# renaming to what `statsExpressions` expects
df <- dplyr::rename(mag, estimate = yi, std.error = sei)

# making subtitle
expr_meta_parametric(
  data = df,
  k = 3,
  messages = FALSE
)

# making caption
expr_meta_parametric(
  data = df,
  k = 2,
  messages = FALSE,
  output = "caption"
)
}
}
