% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_easystats.R
\name{tidy_model_parameters}
\alias{tidy_model_parameters}
\title{Convert \code{parameters} package output to \code{tidyverse} conventions}
\usage{
tidy_model_parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods. Non-documented
arguments are \code{digits}, \code{p_digits}, \code{ci_digits} and
\code{footer_digits} to set the number of digits for the output.
\code{group} can also be passed to the \code{print()} method. See details
in \code{\link[parameters:print.parameters_model]{print.parameters_model()}} and 'Examples' in
\code{\link[parameters:model_parameters.default]{model_parameters.default()}}.}
}
\description{
Convert \code{parameters} package output to \code{tidyverse} conventions
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
tidy_model_parameters(model)
}
