% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_fct.R, R/stabilize_fct_scalar.R,
%   R/to_fct.R, R/to_fct_scalar.R
\name{stabilize_fct}
\alias{stabilize_fct}
\alias{stabilize_fct_scalar}
\alias{to_fct}
\alias{to_fct_scalar}
\title{Ensure a factor argument meets expectations}
\usage{
stabilize_fct(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  min_size = NULL,
  max_size = NULL,
  levels = NULL,
  to_na = character(),
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_fct_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  levels = NULL,
  to_na = character(),
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_fct(
  x,
  allow_null = TRUE,
  levels = NULL,
  to_na = character(),
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_fct_scalar(
  x,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  levels = NULL,
  to_na = character(),
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{These dots are for future extensions and should be empty.}

\item{allow_null}{Logical. Is NULL an acceptable value?}

\item{allow_na}{Logical. Are NA values ok?}

\item{min_size}{Integer. The minimum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{Integer. The maximum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{levels}{Character. Expected levels. If \code{NULL} (default), the levels
will be computed by \code{\link[base:factor]{base::factor()}}.}

\item{to_na}{Character. Values to coerce to \code{NA}.}

\item{x_arg}{Character. An argument name for x. The automatic value will work
in most cases, or pass it through from higher-level functions to make error
messages clearer in unexported functions.}

\item{call}{The execution environment of the call. See the \code{call} argument of
\code{rlang::abort()} for more information.}

\item{x_class}{Character. The class name of \code{x} to use in error messages. Use
this if you remove a special class from \code{x} before checking its coercion,
but want the error message to match the original class.}

\item{allow_zero_length}{Logical. Are zero-length vectors acceptable?}
}
\value{
The argument as a factor.
}
\description{
\code{to_fct()} checks whether an argument can be coerced to
a factor without losing information, returning it silently if so.
Otherwise an informative error message is signaled.

\code{stabilize_fct()} can check more details about the argument, but is slower
than \code{to_fct()}.

\code{stabilize_fct_scalar()} and \code{to_fct_scalar()} are optimized to check for
length-1 factors.
}
\details{
These functions have important differences from \code{\link[base:factor]{base::as.factor()}} and
\code{\link[base:factor]{base::factor()}}:
\itemize{
\item Values are never silently coerced to \code{NA} unless they are explicitly
supplied in the \code{to_na} argument.
\item \code{NULL} values can be rejected as part of the call to this function (with
\code{allow_null = FALSE}).
}
}
\examples{
to_fct("a")
to_fct(1:10)
to_fct(NULL)
try(to_fct(letters[1:5], levels = c("a", "c"), to_na = "b"))

to_fct_scalar("a")
try(to_fct_scalar(letters))

stabilize_fct(letters)
try(stabilize_fct(NULL, allow_null = FALSE))
try(stabilize_fct(c("a", NA), allow_na = FALSE))
try(stabilize_fct(c("a", "b", "c"), min_size = 5))
try(stabilize_fct(c("a", "b", "c"), max_size = 2))

stabilize_fct_scalar("a")
try(stabilize_fct_scalar(letters))
try(stabilize_fct_scalar("c", levels = c("a", "b")))
}
