% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_density_dependence-functions.R
\name{ceiling_density}
\alias{ceiling_density}
\title{Ceiling-based density dependence}
\usage{
ceiling_density(stages = NULL)
}
\arguments{
\item{stages}{which life-stages contribute to density dependence and are removed in a timestep
- default is all}
}
\description{
In-built density dependence function that constrains the number of individuals in a cell
based on the carrying capacity of that cell in a timestep. Note, carrying_capacity must
be provided in the landscape object to use this function (see \link[steps]{landscape}).
Only specified stages that contribute to density dependence are considered in the
calculations and excess individuals are removed from only the contributing stages. This
type of density dependence only affects the population once it reaches the carrying
capacity. While population size is below carrying capacity, the population grows according
to the transition matrix.
}
\examples{

# Cap the population at carrying capacity with only the second and third
# life stage used in calculations to determine density dependence. 

\dontrun{
cap_population <- ceiling_density(stages = c(2, 3))

ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat), density_dependence = cap_population)

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
