% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_results-class.R
\name{extract_spatial}
\alias{extract_spatial}
\title{Extract spatial object from a 'simulation_results' object}
\usage{
extract_spatial(
  x,
  replicate = 1,
  timestep = 1,
  landscape_object = "population",
  stage = 1,
  misc = 1
)
}
\arguments{
\item{x}{a simulation_results object}

\item{replicate}{which replicate to extract from a \code{simulation_results}
object}

\item{timestep}{which timestep to extract from a \code{simulation_results}}

\item{landscape_object}{which landscape object to extract from a
\code{simulation_results} object - can be specified by name
(e.g. "suitability") or index number}

\item{stage}{which life-stage to extract from a \code{simulation_results}
object - only used for 'population' components of the landscape object}

\item{misc}{which misc object to extract from a \code{simulation_results}
object - only used for additional spatial objects added to a landscape
(e.g. disturbance layers)}
}
\description{
The simulation results object is a list of lists containing spatial (and other) objects and
is organised by the following tree diagram:
\itemize{
  \item{Replicate}
  \itemize{
    \item{Timestep}
    \itemize{
      \item{Population Raster Stack}
      \itemize{
        \item{Life-Stage Raster}
      }
      \item{Habitat Suitability Raster (or Stack)}
      \itemize{
        \item{Habitat Raster (if stack is used)}
      }
      \item{Carrying Capacity Raster}
      \item{Other Raster Stack}
      \itemize{
        \item{Raster}
      }
      \item{...}
    }
  }
}
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kernel_dispersal(max_distance = 2000,
                                        dispersal_kernel = exponential_dispersal_kernel(
                                          distance_decay = 1000)),
                          density_dependence = ceiling_density())

sim <- simulation(landscape = ls,
                  population_dynamics = pd,
                  habitat_dynamics = NULL,
                  timesteps = 20)

# Extract the population raster for the second life-stage in the first
# replicate and ninth timestep
extract_spatial(sim, replicate = 1, timestep = 9, stage = 2)
}
}
