% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_refs.R
\name{print_refs}
\alias{print_refs}
\title{Print and Format \code{.bib} Entries as References}
\usage{
print_refs(
  bib,
  csl = "american-political-science-association.csl",
  toformat = "latex",
  cslrepo = "https://raw.githubusercontent.com/citation-style-language/styles/master",
  spit_out = TRUE,
  delete_after = TRUE
)
}
\arguments{
\item{bib}{a valid \code{.bib} entry}

\item{csl}{a CSL file, matching one available on the Github repository, that the user wants to format the references. Default is "american-political-science-association.csl".}

\item{toformat}{the output wanted by the user. Default is "latex".}

\item{cslrepo}{a directory of CSL files. Defaults to the one on Github.}

\item{spit_out}{logical, defaults to TRUE. If TRUE, wraps ("spits out") formatted citations in a \code{writeLines()} output for the console. If `FALSE`, returns a character vector.}

\item{delete_after}{logical, defaults to TRUE. If TRUE, deletes CSL file when it's done. If FALSE, retains CSL for (potential) future use.}
}
\value{
\code{print_refs()} takes a \code{.bib} entry and returns a formatted reference from it.
}
\description{
\code{print_refs()} is a convenience function I found and edited that will allow a user to print and format
\code{.bib} entries as if they were references. This function is useful if you want to load a \code{.bib} entry or set of
entries and print them in the middle of a document in R Markdown.
}
\details{
\code{print_refs()} assumes an active internet connection in the absence of the appropriate CSL file in the
working directory. The citation style language (CSL) file supplied by the user must match a file in the
massive Github repository of CSL files. Users interested in potential outputs should read more about Pandoc (\url{https://pandoc.org/MANUAL.html}).
The Github repository of CSL files is available here: \url{https://github.com/citation-style-language/styles}.
}
\examples{

\donttest{
example <- "@Book{vasquez2009twp, Title = {The War Puzzle Revisited},
Author = {Vasquez, John A}, Publisher = {New York, NY: Cambridge University Press},
Year = {2009}}"

print_refs(example)
}
}
