% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csb_filter.R
\name{csb_filter}
\alias{csb_filter}
\title{Subset Based on Call Categories}
\usage{
csb_filter(.data, var, category)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{name of the column containing original problem code data}

\item{category}{a vector with the unquoted name(s) of the category(s) for the function to return.
You can also explicitly state quoted problemcode(s). Valid categories are: admin, animal,
construction, debris, degrade, disturbance, event, health, landscape, law, maintenance, nature,
road, sewer, traffic, vacant, and waste. If categories are listed, each should be preceded by
'cat_'.}
}
\value{
\code{csb_filter} returns data with an additional variable for an intelligible category for CSB requests.
}
\description{
\code{csb_filter} returns observations that match any combination of the predefined
    categories that are created
}
\examples{
csb_filter(january_2018, var = problemcode, category = cat_vacant)
csb_filter(january_2018, var = problemcode, category = c(cat_waste, cat_debris))
csb_filter(january_2018, var = problemcode, category = "WTR-COMING-UP")

}
