% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDesignMatrix.R
\name{makeDesignMatrix}
\alias{makeDesignMatrix}
\title{Make a Design Matrix}
\usage{
makeDesignMatrix(formula, origData, newData, test = TRUE,
  sparse = TRUE)
}
\arguments{
\item{formula}{the formula describing the design matrix.  Any responses will be deleted}

\item{origData}{the original dataset as a dataframe}

\item{newData}{a dataframe containing any of the variables in the formula.  This will provide
the data in the returned model matrix.}

\item{test}{when set to TRUE runs a test that the matrix was constructed correctly
see details for more.}

\item{sparse}{by default returns a sparse matrix using \code{\link[Matrix]{sparse.model.matrix}} in 
\pkg{Matrix}}
}
\description{
Create a sparse model matrix which respects the basis functions
of the original data on which it was created. Primarily for internal
use but may be of some independent interest.
}
\details{
This functions is designed to be used in settings where we need
to make a prediction using a model matrix.  The practical challenge
here is ensuring that the representation of the data lines up
with the original representation.  This becomes challenging for
functions that produce a different representation depending on their
inputs. A simple conceptual example is factor variables.  If we run 
our original model using a factor with levels \code{c("A","B", "C")}
then when we try to make predictions for data having only levels
\code{c("A","C")} we need to adjust for the missing level.  Base
R functions like \code{\link{predict.lm}} in \pkg{stats} handle 
this gracefully and this function is essentially a version of 
\code{\link{predict.lm}} that only constructs the model matrix.

Beyond factors the key use case for this are basis functions like
splines.  For a function like this to work it must either depend only
on the observation it is transforming (e.g. \code{\link{log}}) or it must
have a generic for \code{\link{predict}} and \code{\link{makepredictcall}}.
The spline wrapper \code{\link{s}} has both and so should work.

When a function lacks these methods it will still produce a design matrix
but the values will be wrong.  To catch these settings we implement a quick
test when \code{test=TRUE} as it is by default.  To test we simply split
the original data in half and ensure that looking at each half separately produces
the same values as the complete original data.
}
\examples{
foo <- data.frame(response=rnorm(30),
                  predictor=as.factor(rep(c("A","B","C"),10)), 
                  predictor2=rnorm(30))
foo.new <- data.frame(predictor=as.factor(c("A","C","C")), 
                      predictor2=foo$predictor2[1:3])
makeDesignMatrix(~predictor + s(predictor2), foo, foo.new)
}
\seealso{
\code{\link{fitNewDocuments}}
}
\keyword{internal}
