\name{findThreshold}
\alias{findThreshold}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Find appropriate threshold range
}
\description{
This function performs a grid search over potential clustering thresholds to identify a valid range, and inspect the varying levels of aggregation within it.
}
\usage{
findThreshold(mod, documents_raw=NULL, documents_matrix=NULL, 
              range_min=.05, range_max=5, step=.05)
}
\arguments{
  \item{mod}{
A fitted \code{STM} object from \pkg{stm}.  
}
  \item{documents_raw}{
  The raw documents used to generate the STM model. A character vector where each entry is the full text of a document.
  }
  \item{documents_matrix}{
  Document-term matrix representation of the raw documents, as generated by the \code{\link[stm]{prepDocuments}} function.
  }
\item{range_min}{
	Lower bound of the range to be searched.
 }
 \item{range_max}{
  Upper bound of the range to be searched.
 }
 \item{step}{
  Step size for the grid search.
 }
}
\value{
 A data frame containing the following columns:
  \enumerate{
   \item \emph{threshold}: Threshold value.
   \item \emph{valid}: Binary value; 1 if clustering is successful using given threshold; 0 if not.
   \item \emph{juncture_points}: Number of juncture points in the resulting clustering tree; -1 if run is unsuccessful. Lower threshold values yield a higher number of juncture points, corresponding to more binary splits and deeper trees. Higher threshold values produce fewer juncture points, corresponding to trees that have significant breadth rather than depth.
 }
}

\seealso{
   \code{\link{stmCorrViz}}
}

