% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_transformation.R
\name{compute_contrast_bcf_model}
\alias{compute_contrast_bcf_model}
\title{Compute a contrast between two outcome prediction specifications for a BCF model}
\usage{
compute_contrast_bcf_model(
  object,
  X_0,
  X_1,
  Z_0,
  Z_1,
  propensity_0 = NULL,
  propensity_1 = NULL,
  rfx_group_ids_0 = NULL,
  rfx_group_ids_1 = NULL,
  rfx_basis_0 = NULL,
  rfx_basis_1 = NULL,
  type = "posterior",
  scale = "linear"
)
}
\arguments{
\item{object}{Object of type \code{bcfmodel} containing draws of a Bayesian causal forest model and associated sampling outputs.}

\item{X_0}{Covariates used for prediction in the "control" case. Must be a matrix or dataframe.}

\item{X_1}{Covariates used for prediction in the "treatment" case. Must be a matrix or dataframe.}

\item{Z_0}{Treatments used for prediction in the "control" case. Must be a matrix or vector.}

\item{Z_1}{Treatments used for prediction in the "treatment" case. Must be a matrix or vector.}

\item{propensity_0}{(Optional) Propensities used for prediction in the "control" case. Must be a matrix or vector.}

\item{propensity_1}{(Optional) Propensities used for prediction in the "treatment" case. Must be a matrix or vector.}

\item{rfx_group_ids_0}{(Optional) Test set group labels used for prediction from an additive random effects
model in the "control" case. We do not currently support (but plan to in the near future), test set evaluation
for group labels that were not in the training set. Must be a vector.}

\item{rfx_group_ids_1}{(Optional) Test set group labels used for prediction from an additive random effects
model in the "treatment" case. We do not currently support (but plan to in the near future), test set evaluation
for group labels that were not in the training set. Must be a vector.}

\item{rfx_basis_0}{(Optional) Test set basis for used for prediction from an additive random effects model in the "control" case.  Must be a matrix or vector.}

\item{rfx_basis_1}{(Optional) Test set basis for used for prediction from an additive random effects model in the "treatment" case. Must be a matrix or vector.}

\item{type}{(Optional) Aggregation level of the contrast. Options are "mean", which averages the contrast evaluations over every draw of a BCF model, and "posterior", which returns the entire matrix of posterior contrast estimates. Default: "posterior".}

\item{scale}{(Optional) Scale of the contrast. Options are "linear", which returns a contrast on the original scale of the mean forest / RFX terms, and "probability", which transforms each contrast term into a probability of observing \code{y == 1} before taking their difference. "probability" is only valid for models fit with a probit outcome model. Default: "linear".}
}
\value{
List of prediction matrices or single prediction matrix / vector, depending on the terms requested.
}
\description{
Compute a contrast using a BCF model by making two sets of outcome predictions and taking their difference.
For simple BCF models with binary treatment, this will yield the same prediction as requesting \code{terms = "cate"}
in the \code{predict.bcfmodel} function. For more general models, such as models with continuous / multivariate treatments or
an additive random effects term with a coefficient on the treatment, this function provides the flexibility to compute a
any contrast of interest by specifying covariates, treatment, and random effects bases and IDs for both sides of a two term
contrast. For simplicity, we refer to the subtrahend of the contrast as the "control" or \code{Y0} term and the minuend of the
contrast as the \code{Y1} term, though the requested contrast need not match the "control vs treatment" terminology of a classic
two-arm experiment. We mirror the function calls and terminology of the \code{predict.bcfmodel} function, labeling each prediction
data term with a \code{1} to denote its contribution to the treatment prediction of a contrast and \code{0} to denote inclusion in the
control prediction.
}
\examples{
n <- 500
p <- 5
X <- matrix(runif(n*p), ncol = p)
mu_x <- (
    ((0 <= X[,1]) & (0.25 > X[,1])) * (-7.5) +
    ((0.25 <= X[,1]) & (0.5 > X[,1])) * (-2.5) +
    ((0.5 <= X[,1]) & (0.75 > X[,1])) * (2.5) +
    ((0.75 <= X[,1]) & (1 > X[,1])) * (7.5)
)
pi_x <- (
    ((0 <= X[,1]) & (0.25 > X[,1])) * (0.2) +
    ((0.25 <= X[,1]) & (0.5 > X[,1])) * (0.4) +
    ((0.5 <= X[,1]) & (0.75 > X[,1])) * (0.6) +
    ((0.75 <= X[,1]) & (1 > X[,1])) * (0.8)
)
tau_x <- (
    ((0 <= X[,2]) & (0.25 > X[,2])) * (0.5) +
    ((0.25 <= X[,2]) & (0.5 > X[,2])) * (1.0) +
    ((0.5 <= X[,2]) & (0.75 > X[,2])) * (1.5) +
    ((0.75 <= X[,2]) & (1 > X[,2])) * (2.0)
)
Z <- rbinom(n, 1, pi_x)
noise_sd <- 1
y <- mu_x + tau_x*Z + rnorm(n, 0, noise_sd)
test_set_pct <- 0.2
n_test <- round(test_set_pct*n)
n_train <- n - n_test
test_inds <- sort(sample(1:n, n_test, replace = FALSE))
train_inds <- (1:n)[!((1:n) \%in\% test_inds)]
X_test <- X[test_inds,]
X_train <- X[train_inds,]
pi_test <- pi_x[test_inds]
pi_train <- pi_x[train_inds]
Z_test <- Z[test_inds]
Z_train <- Z[train_inds]
y_test <- y[test_inds]
y_train <- y[train_inds]
mu_test <- mu_x[test_inds]
mu_train <- mu_x[train_inds]
tau_test <- tau_x[test_inds]
tau_train <- tau_x[train_inds]
bcf_model <- bcf(X_train = X_train, Z_train = Z_train, y_train = y_train,
                 propensity_train = pi_train, num_gfr = 10,
                 num_burnin = 0, num_mcmc = 10)
tau_hat_test <- compute_contrast_bcf_model(
    bcf_model, X_0=X_test, X_1=X_test, Z_0=rep(0, n_test), Z_1=rep(1, n_test),
    propensity_0 = pi_test, propensity_1 = pi_test
)
}
