% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localplot.stlgcppm.R
\name{localplot.stlgcppm}
\alias{localplot.stlgcppm}
\title{Plot the coefficients of a fitted local LGCP model}
\usage{
localplot.stlgcppm(x, par = TRUE)
}
\arguments{
\item{x}{An object of class \code{stlgcppm}}

\item{par}{Default to \code{TRUE}.}
}
\description{
The function plots the local estimates.
In the case of local covariance parameters, the function
displays the local estimates of the chosen covariance function.
}
\examples{
\dontrun{
catsub <- stp(greececatalog$df[1:100, ])

lgcp_loc <- stlgcppm(catsub, formula = ~ x, first = "local")

localplot.stlgcppm(lgcp_loc)

}




}
\references{
D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.
}
\seealso{
\link{stlgcppm}, \link{print.stlgcppm}, \link{summary.stlgcppm},
\link{localsummary.stlgcppm}, \link{plot.stlgcppm}
}
\author{
Nicoletta D'Angelo and Giada Adelfio
}
