% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoploss.R
\name{stoploss}
\alias{stoploss}
\title{Calculate the weighted multiobjective loss function used in STOPS}
\usage{
stoploss(
  obj,
  stressweight = 1,
  structures = c("cclusteredness", "clinearity", "cdependence", "cmanifoldness",
    "cassociation", "cnonmonotonicity", "cfunctionality", "ccomplexity", "cfaithfulness",
    "cregularity", "chierarchy", "cconvexity", "cstriatedness", "coutlying",
    "cskinniness", "csparsity", "cstringiness", "cclumpiness", "cinequality"),
  strucweight = rep(-1/length(structures), length(structures)),
  strucpars,
  stoptype = c("additive", "multiplicative"),
  verbose = 0
)
}
\arguments{
\item{obj}{object returned inside a stop_* function. Uses the stress.m slot for getting the stress.}

\item{stressweight}{weight to be used for the fit measure; defaults to 1}

\item{structures}{which c-structuredness indices to be included in the loss}

\item{strucweight}{the weights of the structuredness indices; defaults to -1/#number of structures}

\item{strucpars}{a list of parameters to be passed to the c-structuredness indices in the same order as the values in structures. If the index has no parameters or you want to use the defaults, supply NULL. (alternatively a named list that has the structure name as the element name).}

\item{stoptype}{what type of weighted combination should be used? Can be 'additive' or 'multiplicative'.}

\item{verbose}{verbose output}
}
\value{
a list with calculated stoploss ($stoploss), structuredness indices ($strucinidices) and hyperparameters ($parameters and $theta)
}
\description{
Calculate the weighted multiobjective loss function used in STOPS
}
