% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_match.R
\name{line_match}
\alias{line_match}
\title{Match two sets of lines based on similarity}
\usage{
line_match(l1, l2, threshold = 0.01, return_sp = FALSE)
}
\arguments{
\item{l1}{A spatial object}

\item{l2}{A spatial object}

\item{threshold}{The threshold for a match - distances greater than this will not count as matches}

\item{return_sp}{Should the function return a spatial result (FALSE by default)}
}
\description{
This function is a wrapper around gDistance that matches lines based on the Hausdorff distance
}
\examples{
x1 = 2:4
x2 = 3:5
match(x1, x2) # how the base function works
l1 = flowlines[2:4,]
l2 = routes_fast[3:5,]
(lmatches = line_match(l1, l2)) # how the stplanr version works
l2matched = l2[lmatches[!is.na(lmatches)],]
plot(l1)
plot(l2, add = TRUE)
plot(l2matched, add = TRUE, col = "red") # showing matched routes
l2matched2 = line_match(l1, l2, return_sp = TRUE)
identical(l2matched, l2matched2)
# decreasing the match likelihood via the threshold
line_match(l1, l2, threshold = 0.003)
}
