% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_local.R
\name{route_local}
\alias{route_local}
\title{Plan a route with local data}
\usage{
route_local(sln, from, to, l = NULL)
}
\arguments{
\item{sln}{The SpatialLinesNetwork to use.}

\item{from}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth.}

\item{to}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth. This represents the destination of the trip.}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}
}
\description{
This function returns the shortest path between locations
in, or near to, segements on a \code{SpatialLinesNetwork}.
}
\examples{
bb = sf::st_bbox(routes_fast)
set.seed(5)
from = c(runif(1, bb$xmin, bb$xmax), runif(1, bb$ymin, bb$ymax))
to = c(runif(1, bb$xmin, bb$xmax), runif(1, bb$ymin, bb$ymax))
sln = SpatialLinesNetwork(routes_fast)
r <- route_local(sln, from, to)
plot(r)
 \dontrun{
# todo: next code chunk is not currently working:
r2 = route_local(sln = sln, cents_sf[5, ], cents_sf[6, ])
plot(r2)
r_many <- line2route(flowlines_sf[2:9, ], route_local, sln = sln)
plot(cents)
plot(sln@sl, add = TRUE)
plot(r_many, add = TRUE)
}
}
