% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnet_join.R
\name{rnet_merge}
\alias{rnet_merge}
\title{Merge route networks, keeping attributes with aggregating functions}
\usage{
rnet_merge(rnet_x, rnet_y, dist = 5, funs = NULL, sum_flows = TRUE, ...)
}
\arguments{
\item{rnet_x}{Target route network, the output will have the same geometries
as features in this object.}

\item{rnet_y}{Source route network. Columns from this route network object will
be copied across to the new network.}

\item{dist}{The buffer width around rnet_y in meters. 1 m by default.}

\item{funs}{A named list of functions to apply to named columns, e.g.:
\code{list(flow = sum, length = mean)}. The default is to sum all numeric
columns.}

\item{sum_flows}{Should flows be summed? \code{TRUE} by default.}

\item{...}{Additional arguments passed to \code{rnet_join}.}
}
\value{
An sf object with the same geometry as \code{rnet_x}
}
\description{
Merge route networks, keeping attributes with aggregating functions
}
\examples{
# The source object:
rnet_y = route_network_small["flow"]
# The target object
rnet_x = rnet_subset(osm_net_example[1], rnet_y)
plot(rnet_x$geometry, lwd = 5)
plot(rnet_y$geometry, add = TRUE, col = "red", lwd = 2)
rnet_y$quietness = rnorm(nrow(rnet_y))
funs = list(flow = sum, quietness = mean)
rnet_merged = rnet_merge(rnet_x[1], rnet_y[c("flow", "quietness")],
                         dist = 9, segment_length = 20, funs = funs)
plot(rnet_y$geometry, lwd = 5, col = "lightgrey")
plot(rnet_merged["flow"], add = TRUE, lwd = 2)

# # Larger example
# system("gh release list")
# system("gh release upload v1.0.2 rnet_*")
# List the files released in v1.0.2:
# system("gh release download v1.0.2")
# rnet_x = sf::read_sf("rnet_x_ed.geojson")
# rnet_y = sf::read_sf("rnet_y_ed.geojson")
# rnet_merged = rnet_merge(rnet_x, rnet_y, dist = 9, segment_length = 20, funs = funs)
}
