% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chull_poly.R
\name{chull_poly}
\alias{chull_poly}
\title{Boundary surrounding a set of points}
\usage{
chull_poly(xycoords,
crsys = NULL)
}
\arguments{
\item{xycoords}{(matrix) A 2-column
coordinate vectors of points: \code{x} - the eastings,
and \code{y} - the northing.}

\item{crsys}{Optional string specifying the coordinate
reference system (crs) of the resulting boundary, e.g.,
the crs string "+proj=longlat +datum=WGS84" transform
the resulting boundary to wgs84 system.}
}
\value{
Returns a "SpatialPolygonsDataFrame"
object representing the boundary
surround the spatial points
}
\description{
Generates a boundary (polygon) around
a set of points, using Convex Hull technique
(Eddy, W. F, 1977).
}
\details{
Draws an arbitrary boundary around
spatial points by joining the outer-most
points by lines.
}
\examples{
data(xyt_data)
#extract xy coordinates only
xy <- matrix(as.numeric(xyt_data[,1:2]),,2)
bry <- chull_poly(xy, crsys = NULL)
#visualise result
#plot(bry) #to plot
#points(xy[,1], xy[,2], add=TRUE)
}
\references{
Eddy, W. F. (1977).
A new convex hull algorithm for planar sets.
ACM Transactions on Mathematical Software,
3, 398--403.10.1145/355759.355766.
}
