% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{pick}
\alias{pick}
\title{Extract Elements From a (Atomic) Vector}
\usage{
pick(x, val, pat = FALSE, not = FALSE, nm = FALSE, fixed = FALSE)
}
\arguments{
\item{x}{atomic vector or an object with names (e.g., data.frame) if \code{nm} = TRUE.}

\item{val}{atomic vector specifying which elements of \code{x} will be extracted.
If \code{pat} = FALSE (default), then \code{val} should be an atomic vector of
the same typeof as \code{x}, can have length > 1, and exact matching will be done
via \code{is.element} (essentially \code{match}). If \code{pat} = TRUE, then
\code{val} has to be a character vector of length 1 and partial matching will be
done via \code{grepl} with the option of regular expressions if \code{fixed} = FALSE
(default). Note, if \code{nm} = TRUE, then \code{val} should refer to names of
\code{x} to determine which elements of \code{x} should be extracted.}

\item{pat}{logical vector of length 1 specifying whether \code{val} should refer to
exact matching (FALSE) via \code{is.element} (essentially \code{match}) or partial
matching (TRUE) and/or use of regular expressions via \code{grepl}. See details
for a brief description of some common symbols and \code{help(regex)} for more.}

\item{not}{logical vector of length 1 specifying whether \code{val} indicates
values that should be retained (FALSE) or removed (TRUE).}

\item{nm}{logical vector of length 1 specifying whether \code{val} refers to the
names of \code{x} (TRUE) rather than the elements of \code{x} themselves (FALSE).}

\item{fixed}{logical vector of length 1 specifying whether \code{val} refers to
values as is (TRUE) or a regular expression (FALSE). Only used if \code{pat} = TRUE.}
}
\value{
a subset of \code{x} that only includes the elements which meet the criteria
specified by the function call.
}
\description{
\code{pick} extracts the elements from a (atomic) vector that meet certain criteria:
1) using exact values or regular expressions (\code{pat}), 2) inclusion vs.
exclusion of the value/expression (\code{not}), 3) based on elements or names (\code{nm}).
Primarily for character vectors, but can be used with other typeof.
}
\details{
\code{pick} allows for 8 different ways to extract elements from a (atomic) vector
created by the 2x2x2 combination of logical arguments \code{pat}, \code{not}, and \code{nm}.
When \code{pat} = FALSE (default), \code{pick} uses \code{is.element} (essentially
\code{match}) and requires exact matching of \code{val} in \code{x}. When \code{pat}
= TRUE, \code{pick} uses \code{grepl} and allows for partial matching of \code{val}
in \code{x} and/or regular expressions if \code{fixed} = FALSE (default).

When dealing with regular expressions via \code{pat} = TRUE and \code{fixed} = FALSE,
certain symbols within \code{val} are not interpreted as literal characters and
instead have special meanings. Some of the most commonly used symbols are \code{.}
= any character, \code{"|"} = logical or, \code{"^"} = starts with, \code{"\\n"} = new line,
\code{"\\t"} = tab.
}
\examples{
# pedagogical cases
chr <- setNames(object = c("one","two","three","four","five"), nm = as.character(1:5))
# 1) pat = FALSE, not = FALSE, nm = FALSE
pick(x = chr, val = c("one","five"), pat = FALSE, not = FALSE, nm = FALSE)
# 2) pat = FALSE, not = FALSE, nm = TRUE
pick(x = chr, val = c("1","5"), pat = FALSE, not = FALSE, nm = TRUE)
# 3) pat = FALSE, not = TRUE, nm = FALSE
pick(x = chr, val = c("two","three","four"), pat = FALSE, not = TRUE, nm = FALSE)
# 4) pat = FALSE, not = TRUE, nm = TRUE
pick(x = chr, val = c("2","3","4"), pat = FALSE, not = TRUE, nm = TRUE)
# 5) pat = TRUE, not = FALSE, nm = FALSE
pick(x = chr, val = "n|v", pat = TRUE, not = FALSE, nm = FALSE)
# 6) pat = TRUE, not = FALSE, nm = TRUE
pick(x = chr, val = "1|5", pat = TRUE, not = FALSE, nm = TRUE)
# 7) pat = TRUE, not = TRUE, nm = FALSE
pick(x = chr, val = "t|r", pat = TRUE, not = TRUE, nm = FALSE)
# 8) pat = TRUE, not = TRUE, nm = TRUE
pick(x = chr, val = c("2|3|4"), pat = TRUE, not = TRUE, nm = TRUE)
datasets <- data()[["results"]][, "Item"]
# actual use cases
pick(x = datasets, val = c("attitude","mtcars","airquality"),
   not = TRUE) # all but the three most common datasets used in `str2str` package examples
pick(x = datasets, val = "state", pat = TRUE) # only datasets that contain "state"
pick(x = datasets, val = "state.*state", pat = TRUE) # only datasets that have
   # "state" twice in their name
pick(x = datasets, val = "US|UK", pat = TRUE) # only datasets that contain
   # "US" or "UK"
pick(x = datasets, val = "^US|^UK", pat = TRUE) # only datasets that start with
   # "US" or "UK"
pick(x = datasets, val = "k.*o|o.*k", pat = TRUE) # only datasets containing both
   # "k" and "o"
}
