% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stranger.R
\name{strange}
\alias{strange}
\alias{stranger}
\title{Computes anomaly metrics by invoking specific method(s) with associated sets of parameters}
\usage{
strange(data, weird = "knn", tuneGrid = NULL, colname = NULL, ...)
}
\arguments{
\item{data}{crazy data, ie outcome of a call to \code{\link{crazyfy}}.}

\item{weird}{Weird method to be used - for the list of available methods, use \code{weirds_list}.}

\item{tuneGrid}{(optional) vector or data.frame of values for the parameters of the invoked method.}

\item{colname}{(optional) character - name to be given to the resulting anomaly metric computation (distance/probability).}

\item{\dots}{additional parameters to be passed to the invoked \emph{weird} method.}
}
\value{
stranger object -- that is a data.table with attributes and overloaded with class stranger
}
\description{
\code{strange} invokes a \emph{weird} method -- that is a wrapper around a
pre-existing anomaly detection measure (distance, probability...). \code{stranger}
allows to invoke several \emph{weird} methods in a single call.
}
\details{
You will use \code{strange} to use one method and may be interested by \code{stranger}
if you wants to apply different methods in a single call.
When comparing \code{stranger} package with \code{caret}, \code{strange} function is the
equivalent of \code{train}, where as \code{stranger} corresponds to \code{caretEnsemble}
function and package.
}
\examples{
\dontrun{
library(stranger)
data(iris)
crazydata <- crazyfy(iris[,1:4])
curious <- strange(crazydata, weird="knn")
}
}
