% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weirds.R
\name{weird_knn}
\alias{weird_knn}
\alias{weird_lof}
\alias{weird_autoencode}
\alias{weird_abod}
\alias{weird_pcout}
\alias{weird_isofor}
\alias{weird_kmeans}
\alias{weird_mahalanobis}
\alias{weird_randomforest}
\title{weirdness wrappers for available anomalies detection methods}
\usage{
weird_knn(data = NULL, info = FALSE, colname = NULL, simplify = "mean",
  ...)

weird_lof(data = NULL, info = FALSE, colname = NULL, ...)

weird_autoencode(data = NULL, info = FALSE, colname = NULL, ...)

weird_abod(data = NULL, info = FALSE, colname = NULL, ...)

weird_pcout(data = NULL, info = FALSE, colname = NULL, ...)

weird_isofor(data = NULL, info = FALSE, colname = NULL, ...)

weird_kmeans(data = NULL, info = FALSE, colname = NULL, type = "means",
  ...)

weird_mahalanobis(data = NULL, info = FALSE, colname = NULL, ...)

weird_randomforest(data = NULL, info = FALSE, colname = NULL, ...)
}
\arguments{
\item{data}{data pre-processed with \code{\link{crazyfy}} function}

\item{info}{logical: either run the function (default) or simply return some
information about it}

\item{colname}{character: optional prefix to be used to prepare the naming
of the generated column. All weird methods do have a default prefix (applied when
colname is \code{NULL}). Note that generated output column name will still have some
information added to reflect values used for some key parameters.}

\item{simplify}{character of function - used by knn to aggregates distances
to nearest k points.}

\item{\dots}{additional parameters to be passed to weird method, for instance k for knn}

\item{type}{one of "means" or "euclidian". See \code{kmeans} from \code{stats} package.}
}
\description{
Those wrapper are mainly used internally by other functions and the
recommended way is to start your detection process by using one of:
 \code{\link{strange}}, \code{\link{stranger}} or \code{\link{lucky_odds}} functions.
}
\details{
For each weird wrapper, please refer to the documentation of the underlying
function in its package.
}
